Annual Review of Psychology

# Stress and Health: A Review of Psychobiological Processes

Daryl B. O'Connor,1 Julian F Thayer,2   
and Kavita Vedhara³

1SchoolofPsychology, UniversityofLeeds,Leeds LS29JT, United Kingdom;   
email: d.b.oconnor@leeds.ac.uk   
2Department of Psychological Science,School of Social Ecology, University of California, Irvine,California 92697,USA; email: jfthayer@uci.edu   
3Division of Primary Care,School of Medicine,University of Nottingham,   
Nottingham NG7 2UH, United Kingdom; email: kavita.vedhara@nottingham.ac.uk

Annu. Rev. Psychol. 2021. 72:663-88

First published as a Review in Advance on September 4,2020

The Annual Review ofPsychology isonlineat psych.annualreviews.org

https://doi.org/10.1146/annurev-psych-062520- 122331

Copyright $\circledcirc 2 0 2 1$ by Annual Reviews. All rights reserved

# EMIEWS CONNECT

# www.annualreviews.org

·Download figures   
· Navigate cited references   
· Keyword search   
· Explore relatedarticles   
· Share via email or social media

# Keywords

allostatic load, cortisol, autonomic nervous system, genomics, HPA axis

# Abstract

The cumulative science linking stress to negative health outcomes is vast. Stress can affect health directly, through autonomic and neuroendocrine responses, but also indirectly, through changes in health behaviors. In this review, we present a brief overview of $( a )$ why we should be interested in stress in the context of health; $( b )$ the stress response and allostatic load; $( c )$ some of the key biological mechanisms through which stress impacts health, such as by influencing hypothalamic-pituitary-adrenal axis regulation and cortisol dynamics, the autonomic nervous system, and gene expression; and (d) evidence of the clinical relevance of stress, exemplified through the risk of infectious diseases.The studies reviewed in this article confirm that stress has an impact on multiple biological systems. Future work ought to consider further the importance of early-life adversity and continue to explore how different biological systems interact in the context of stress and health processes.

# Contents

INTRODUCTION 664   
WHY SHOULD WE BE INTERESTED IN STRESS? . 665 Stress and Health: The Basics 666 The Stress Response . 666   
KEY BIOLOGICAL MECHANISMS THROUGH WHICH STRESS IMPACTS HEALTH. 667 Effects of Stress on HPA Axis Regulation and Cortisol Dynamics ... 667 Cortisol Responses to Stress and Future Health Risk 667 Stress, Cortisol Awakening Response, and Health Outcomes .. 669 Stress, the Diurnal Cortisol Slope,and Health Outcomes . 670 Stress and Hair Cortisol. 671 Effects of Stress on Autonomic Nervous System Regulation and Dynamics 671 Effects of Stress on Blood Pressure,Heart Rate,Heart Rate Variability, and Their Dynamics . 672 The Role of Social Genomics in Elucidating the Relationship Between Stress and Health . 674 Stress Results Not in the Downregulation but in the Dysregulation of Immunity 674 Enhancing Our Understanding of the Role Played by Cortisol .. 675 Interventions and Gene Expression: A Promising Area of Enquiry. 675   
THE CLINICAL RELEVANCE OF STRESS: THE CASE OFINFECTIOUS DISEASES 676 The Obstacles Inherent in Examining the Clinical Relevance of Stres ... 676 Viral Challenge Studies 677 Vaccine Studies . 679 So, Does It Matter? 680   
THE IMPORTANCE OF EARLY-LIFE ADVERSITY FOR STRESS AND HEALTH PROCESSES 680   
CONCLUSION. 681

# INTRODUCTION

On the 18th of May 1936,Hans Seyle published a 595-word letter in Nature entitled“A syndrome produced by diverse nocuous agents”(Selye 1936).This landmark document described what would later become known as the general adaptation syndrome, which would be the subject of an early Annual Review ofMedicine paper (Selye 1951) and of an influential "sketch"by Selye (1950,p.1383) in which he argued that “anything that causes stress endangers life,unless it is met by adequate adaptive responses; conversely,anything that endangers life causes stress and adaptive responses. Adaptability and resistance to stress are fundamental prerequisites for life,and every vital organ and function participates in them.” In the intervening 7O years, Selye's early work has triggered a gargantuan scientific effort aimed at understanding adaptability, resistance,and ultimately the pathways through which stressinfluences health,disease,and longevity.

This review is not intended to provide a comprehensive overview of the enormous scientific literature investigating how large or small,acute or chronic,historical or recent,laboratory-based or naturalistic stressul events lead to il-health, disease,and reduced life expectancy. Instead, we aim to present a brief overview of $( a )$ why we should be interested in stress in the context of health, $( b )$ how and through which mechanisms stress affects health,and (c) why it matters,that is, what the evidence tells us about the relation between stress and clinically meaningful changes in our health.Finaly, we consider an important area of research that looks at the health consequences of previous stressful experiences in the form of early-life adversity. Along the way, we highlight exciting new developments and unanswered questions and point to promising future directions for research.

# Allostatic load:

wear and tear the body experiences due to repeated stress exposure

# WHYSHOULDWEBEINTERESTEDINSTRESS?

Stress is now part of our everyday vernacular and is central to the human condition.Scientific interest in stress dates back at least to World War I, when soldiers were found to exhibit shellshock,an extreme reaction to the trauma of battle that was subsequently acknowledged to be a manifestation of post-traumatic stress disorder (Lazarus 1999). The increase in media coverage over many decades has corresponded with an exponential growth in research and public awareness of stress and its effects.In many countries around the world,stress is recognized as a leading cause of long-term sickness,accounting for millions of working days lost (e.g.,Am.Psychol. Assoc.2019, UKHealth Saf.Executive 2019). Stress is the focus of bestselling books,front covers of Time magazine,and the subject of novels,plays,and movies.We are interested in stress because it is everywhere.It impacts everyone and pervades all aspects of our lives.Moreover,it is now well established that stress can affect health directly,through autonomic and neuroendocrine responses (the subject of the current review), but also indirectly,through changes to health behaviors (e.g., Hill et al.2018,O'Connor et al. 2008,Tomiyama 2019).In the latter case,stress may indirectly contribute to obesity,cardiovascular disease,and cancer risk to the extent that it produces deleterious changes in diet and/or helps maintain unhealthy eating behaviors such as high fat intake or low fiber or fruit/vegetable intake.

Nevertheless, the usefulness of the concept of stress has recently been called into question. Kagan (2O16) argued that the overly permissive use of classifying any event as a stressor just because it leads to biological or behavioral change limits its utility. Instead,he argues that the concept of stress should only be applied to events that ultimately pose a serious threat to an organism's well-being.Leading theorists and stress researchers have challenged this view. One group has argued tat the concept of stress is useful as long as it is understood in biological terms within a broader framework of allostasis and allostatic load,adaptation to positive and negative life experiences,and resultant health behaviors (McEwen & McEwen 2Ol6). Another group of researchers has made a convincing case for the utility of stress as a valuable heuristic that has allowed researchers to integrate different traditions in the study of stress—epidemiological, psychological, and biological—into a stage model of stress and disease (Cohen et al.2O16).In an earlier article, Segerstrom & O'Connor (2O12) have argued that the concept of stress has a long and productive history but also has its detractors, who point out the imprecise and simplistic use of the term. For example, stress can be located in the environment (e.g.,a noxious stimulus in one's environment),in appraisal(e.g.,the extent to which a threatening encounter is appraised as stressful),or in response (e.g., the emotional or physiological response to a stressor); therefore,careful conceptualization and assessment are needed to differentiate among these locales and to reveal interactions among them.Indeed, these issues are echoed by Slavich (2O19), who introduced the notion of stressnology to describe the problematic and primitive approach to studying the effects of life stress exposure on human health and called for better measurement and use of state-of-the-art instruments. Notwithstanding these issues,we contend that the cumulative science linking stress to negative health outcomes is robust. Indeed, the fact that these relationships are evident, even in the face of concerns regarding imprecision in the conceptualization and measurement of stress, attests to the importance of stress for health.

Cortisol: the stress hormone

ANS: autonomic nervous system

HPA axis: hypothalamicpituitary-adrenal axis

SAM system:   
sympathetic-adrenal  
medullary   
system

# Stress and Health: The Basics

In order to survive, the human body is required to continually adapt to the changing internal and external environment. At its most basic level this is known as homeostasis,whereby the human body tightly regulates its internal physiological states (e.g., body temperature, oxygen supply etc.) to keep us alive.In order to maintain homeostasis,our body releases hormones (e.g.,cortisol, adrenaline,and noradrenaline)and switches on the autonomic nervous system (ANS)and the central nervous system to allow us to adapt and respond to day-to-day activities (some of which may be stressful).The release of these so-called physiological mediators (cortisol,adrenaline,and noradrenaline) and changes in immune and metabolic parameters (known as allostasis; see Sterling & Eyer 1988) are protective and adaptive as long as they switch on and switch off in a balanced way when an environmental challenge or stressor is no longer present.However, when this fails to happen and the physiological response is maintained overtime,it can become damaging for our health and well-being.

McEwen (1998) proposed the concept of allostatic load to refer to the wear and tear that the body experiences due to repeated and long-term exposure to stress Moreover, he suggested that allostatic load is characterized by the inefficient switching on and turning off of what he called stress mediators and, in some cases,to the failure of those mediators to mount an adequate response when required (e.g.,if the body releases too little or too much cortisol when faced with an acutely stressful encounter). More broadly, McEwen (1998) proposed that the long-term impact of exposure to stress affects the body at the cardiovascular,metabolic,neural,behavioral,and cellular levels and increases the risk of developing disease because the bodily systems stop working effectively (see McEwen & Seeman 1999). Most recently,McEwen (2018) has discussed the concept of allostatic overload,which describes the harmful effects of stress on our biological systems when a host of stress mediators are released to help us adapt but their excessive, prolonged,and repeated overuse and dysregulation can ultimately lead to damage.At its core,allostatic overload reinforces the notion that stress affects multiple biological systems and that these systems interact with one another to adapt and respond to changing environmental demands that are perceived as stressful.

# The Stress Response

Broadly speaking, two systems are activated when we experience stress. The first and easiest to activate is the sympathetic-adrenal-medullary (SAM) system. The second is the hypothalamicpituitary-adrenal (HPA)axis.When an individual is suddenly under threat or frightened,the brain (the amygdala, then the hypothalamus) instantly activates the ANS to send a messge to the adrenal glands to trigger the release of noradrenaline,which in turn activates the internal organs.This is the basic ANS sympathetic response to threat.However,at the same time,the adrenal medulla releases adrenaline,which is rapidly transported through the bloodstream to further prepare the body to respond. This system is known as the SAM system response.Within seconds adrenaline and noradrenaline have the entire body on alert, the so-called fight-or-flight response.As a result, breathing quickens,the heart beats more rapidly and powerfully, the eyes dilate to allow more light in,and the activity of the digestive system decreases to permit more blood to go to the muscles. This effect is both rapid and intense.

In addition to the SAM response,when an individual experiences an event in their environment that they perceive as stressful,the hypothalamus releases a peptide hormone called corticotrophin releasing factor (CRF). Once released, CRF is transported in the blood supply to the pituitary gland, where it stimulates the release of adrenocorticotrophic hormone (ACTH). Subsequently, ACTH travels through the circulatory system to the adrenal cortex, where it stimulates production of the glucocorticoid cortisol, the so-called stress hormone.One of the central functions of cortisol is to increase access to energy stores,increase protein and fat mobilization,and decrease inflammation. Therefore, when an individual experiences stress,the surge in cortisol triggers the release of excess energy stored in the muscle and liver as glycogen, which is then broken down into glucose ready for utilization by the muscles and the brain.However,it is important to bear in mind that cortisol is a complex hormone and has multiple roles beyond the stress response (McEwen 2019). As discussed below, cortisol plays a key role in regulating circadian rhythm by influencing genomic and nongenomic cellular and molecular mechanisms.

Gene expression: the process by which genes are switched on or become active

# KEYBIOLOGICAL MECHANISMS THROUGHWHICH STRESS IMPACTSHEALTH

Follwing Selye's groundbreaking work, many researchers have attempted to investigate the effects of repeated and long-term stress exposure on physical health outcomes (as wellas on mental health outcomes),and we consider some of this evidence later.At the same time,however, there has also been considerable interest in the key biological mechanisms that mediate the stress-health relationship.For example,what are the causal pathways that link stress to health outcomes such as increased risk of disease onset,faster disease progression,or reduced longevity? Which important biological processes does stress impact before it affects health outcomes? How does stress influence the expression of genes that might have an impact on health? As indicated earlier, the current review cannot possibly summarize al of the accumulated evidence; instead, we focus on three important areas of research that have been influential in improving our understanding of how stress influences health: (a)research investigating the effects of stresson the regulation of the HPA axis and the dynamics of cortisol; $( b )$ work examining the influence of stress on the ANS,especially blood pressure (BP) and heart rate variability (HRV); and (c) exciting recent developments in social genomics showing that gene expression can be influenced by environmental factors such as stress.

# Effects of Stress on HPA Axis Regulation and Cortisol Dynamics

Cortisol is the primary effector hormone of the HPA axis stress response system.Like other aspects of the endocrine system,the HPA axis is regulated by a negative feedback system, whereby the hypothalamus and the pituitary gland have receptors that detect changes in cortisol levelsfor example,cortisol secretion is inhibited when circulating levels rise and is stimulated when levels fall.However, if the HPA axis is repeatedly activated, this triggers increased cortisol output,thereby exposing bodily tissues to excessive concentrations of the hormone (Lovallo 2016; McEwen 1998,2000; Miller et al. 2007). Over time,such repetitive activation may lead to tissue damage and contribute to future ill-health by placing excessive pressure on various bodily systems, including the HPA axis (i.e., allostatic load and overload) (McEwen 1998).

# Cortisol Responses to Stress and Future Health Risk

A considerable body of research has explored whether individuals who exhibit exaggerated cortisol responses to stress are at increased risk of future ill-health (Bunea et al.2O17,Dickerson & Kemeny 2004,Lovallo 2016,Newman et al.2007,Zorn et al.2017). This work has been heavily influenced by what is known as the reactivity hypothesis,first applied to examining cardiovascular reactivity to stress (Obrist 1981) and discussed below, which emphasizes that individuals who exhibit the largest increases in BP or heart rate (HR) in response to acute stressors willbe at greatest risk of future ill-health.In the context of cortisol reactivity,a number of important studies have found evidence that increased cortisol reactivity to stress is associated with negative health outcomes (e.g.,al'Absi & Witmers 2003; Hamer & Steptoe 2012; Hamer et al.2010,2012). For example,alAbsi & Wittmers (2O03) found evidence that enhanced HPA activity in response to an acute stressor was (cross-sectionally) associated with risk of hypertension. Similarly,Hamer et al. (2010),in another cross-sectional investigation,found that heightened reactivity to a stressor was associated with coronary artery calcification (a marker of subclinical coronary atherosclerosis). In a 3-year prospective study of the Whitehall I cohort,Hamer & Steptoe (2O12) found a $5 9 \%$ increase in the odds of incident hypertension per standard deviation change in cortisol responsivity to a stressor. In a separate analysis of the same cohort, this group showed that heightened cortisol reactivity to stress was also associated with progression of coronary artery calcification 3 years later (Hamer et al.2O12).Interestingly, these authors noted considerable variation in the cortisol stress responses,with only $4 0 \%$ of participants exhibiting at least $1 \ \mathrm { m m o l / L }$ increase. What about the other $6 0 \%$ In an exciting development relating to cellular aging, Steptoe et al. (2017) recently found that healthy men and women who were “cortisol responders"to acute stressors had shorter telomeres 3 years later compared to those who were“nonresponders.”These authors argued that cortisol responsivity may mediate,in part, the relationship between psychological stress and cellular aging.

Alongside the work on heightened cortisol reactivity, research has emerged to suggest that smaller increases or blunted cortisol responses to stress may also be indicative of currentill-health or future health risks (Lovallo 2016).Early evidence to suggest that lower cortisol responses to stress are not necessarily protective came from a study of patients who were alcohol dependent and polysubstance abusers.Lovallo et al. (2ooo) found that control patients exhibited the expected cortisol increase following a speech stress test, whereas patients who were diagnosed as alcohol dependent or alcohol and stimulant dependent did not exhibit a significant cortisol increase.These findings indicated that hyporesponsivesness (also known as a blunted response) may also be a marker of dysregulation of HPA axis functioning.

Surprisingly,over the past 2O years,the health effects of low cortisol and/or blunted cortisol reactivity to stress have received less attention.However, findings from the Dutch Famine Birth Cohort Study have been very influential for our understanding not only of the cortisol reactivity hypothesis but also of the cardiovascular reactivity hypothesis (as outlined below).This cohort study is a large population-based investigation of people who were born in Amsterdam between 1943 and 1947, with a subsample of participants who completed an extensive stress protocol between 2002 and 2004 (Roseboom et al.2006).In terms of cortisol reactivity to stress,findings from this study showed that lower cortisol stress reactivity was associated with obesity and the risk of developing obesity and with symptoms of depresson and anxiety (see de Rooij 2013). Numerous other recent studies have showed that low or blunted cortisol reactivity to stress is associated with high levels of chronic stress and increased risk of negative physical and mental health outcomes (e.g.,Lovallo et al.2019,O'Connor et al.2017,Padden et al.2019, Zorn et al.2017).For example,Padden et al. (2O19) reported that blunted cortisol reactivity was the dominant pattern of physiological reactivity that emerged from studies of caregivers of individuals with autism spectrum disorder.In another study, O'Connor et al.(2O17) found that individuals who had previously made a suicide attempt exhibited low levels of cortisol in response to an acute stressor compared to control participants.Moreover, the results of a meta-analysis in the area of early-life adversity found evidence of a robust association between early-life adversity and a blunted cortisol response to social stress (Bunea et al.2017).

Taken together, the evidence is converging to suggest that both heightened and blunted cortisol responses to acute stressors are associated with increased future health risk.To this end, Carroll et al. (2017) have put forward a model of blunted stress reactivity that attempts to integrate the evidence linking exaggerated and blunted stress responses into a single unifying framework.They argue that the health-damaging efects of heightened reactivity to stress are well established especially in relation to cardiovascular pathology; however, our understanding the effects of low or blunted reactivity remains in its infancy.Nevertheless,current theorizing suggests that there is a nonlinear inverted-U relationship,such that high and low levels ofcortisol are likely to be deleterious.Similar relationships have been demonstrated for other hormones and important aspects of behavior (cf. O'Connor et al.2001).

# Stress, Cortisol Awakening Response, and Health Outcomes

The diurnal pattern of cortisol production is characterized by two distinct components: the peak levels after awakening [i.e., the cortisol awakening response (CAR)] and the diminishing levels throughout the rest of the day (i.e.,the diurnal cortisol slope) (Adam et al.2O17, Clow et al.2010, Fries et al. 2009,O'Connor et al. 2009,Pruessner et al. 1997). As outlined above,cortisol plays an important regulatory function for many of the body's basic biological systems (e.g., metabolic, immune,inflammatory processes),and disruption of its diurnal rhythm is likely to afect the functioning of these systems in ways that may have consequences for health over time (Lupien et al. 2009,Sapolsky et al.20o0).A relatively large amount of research has explored the links between diurnal cortisol levels and health outcomes (Adam et al.2O17).We briefly review this literature in the next section,but first we consider the relationship between stress and the CAR.

The CAR,the steep rise in cortisol that occurs in the first 30 to 45 minutes after waking,has been a popular topic of recent research,though its function and regulation are not yet fully understood.There is evidence that the CAR is under different regulatory control from the cortisol that is released across the rest of the day (Clow et al.2010, Schmidt-Reinwald et al.1999). Moreover, it has been theorized that the function of the CAR is to prepare the individual for the demands of the upcoming day (Powell & Schlotz 2O12).The CAR has been linked with stress and a range of health outcomes, though the pattern of results has been mixed (e.g.,Adam et al. 2010, Chida & Steptoe 2009,Clow et al.2010,Gartland et al.2014, O'Connor et al.2013, Steptoe & Serwinski 2016). In terms of psychological stress,a number of studies have found links between stres and increases in the CAR (e.g.,De Vugt et al. 2005,Wust et al. 2000). Conversely, other evidence has shown that chronic stress may disrupt HPA axis regulation and lead to a blunted CAR (e.g., Mortensen et al.2019; O'Connor et al.2009,2013; Steptoe & Serwinski 2016; Thorn et al.2006). Furthermore,in terms of health outcomes,a comprehensive meta-analysis by Chida & Steptoe (2009) confirmed similar findings and reported that different psychosocial factors are associated with both enhanced and reduced cortisol awakening responses. In particular, they found that the CAR was positively associated with job stress and general life stress but negatively associated with fatigue,burnout, exhaustion,and post-traumatic stress syndrome.More recently, using a combination of meta-analysis and P-curve analysis, Boggero et al. (2O17)also found divergent findings, with depression being linked to higher CAR and post-traumatic stress being linked to lower CAR.

Methodological issues likely contributed to these mixed findings (see expert consensus guidelines in Stalder et al. 2O16). Measurement of the CAR is particularly sensitive to protocol violations (e.g., geting out of bed before the frst sample is taken or not providing samples at the correct time).Therefore,future research needs to continue to take steps to minimize issues such as participant nonadherence in order to reduce the noise in these findings (e.g., using electronic containers to collect cortisol samples that record the time of collction). In addition, future studies investigating CAR ought to increase the number of measurement days in order to improve the reliability of the CAR measures (Segerstrom et al.2014).

In terms of the relationship between stress and the CAR, Steptoe & Serwinski (2O16) have argued that higher CAR may be observed under conditions that require individuals to actively cope with the demands of the upcoming day, whereas lower CAR may be observed under severely stressful conditions that cannot be dealt with by active behavioral responses.Alternatively,it is our view that the mixed findings may also be explained in terms of allostatic load and overload.For example,it is possble that moderate to high CAR during periods of increased demand and challenge may reflect the normal adaptive response to a stressful environment (allostatic load). However, in the context of fatigue,post-traumatic stress disorder, and burnout, the lower CAR may reflect dysregulation of the HPA axis following exposure to more severe chronic stress over a long period that is consistent with allostatic overload or so-called toxic stress (McEwen 2018). Indeed, this view is consistent with recent meta-analytical evidence in the context of suicide (O'Connor et al. 2016)and, more generally, with a previous review linking chronic stress and the HPA axis (Miller et al. 2007).

In sum,it is clear that the CAR is an important index ofHPA axis activity and provides valuable insights into the relationship between psychological factors,HPA axis function,health,and wellbeing.As is the case with cortisol reactivity to stress, existing evidence suggests that both low and high CAR may be associated with health risk.Future research ought to establish the precise regulatory function of the CAR,incorporating longitudinal designs and repeated assessments.

# Stress, the Diurnal Cortisol Slope,and Health Outcomes

The variation in cortisol levels across the day is large and reaches its nadir at bedtime.Like the CAR,the diurnal cortisol slope has been the focus of a great deal ofresearch,andit has been argued that the disruption of cortisol's circadian rhythm may affect a large range of central and peripheral biological systems that contribute to negative physical and mental health outcomes over time (Adam et al.2O17,Lupien et al.2Oo9).A substantial number of studies have found that there is an association between a flatter cortisol slope and adverse outcomes such as depression,cardiovascular disease,inflammation, fatigue,obesity,and suicide attempt (Matthews et al.2o06,Nater et al.2008,O'Connor et al.2020b,Schrepf etal.2014,Rutle et al.2013).However,other studies have failed to find associations between the diurnal cortisol slope or have yielded inconsistent or contrary findings (e.g., Turner-Cobb et al.2011,Vedhara et al.2006).

Despite the burgeoning amount of research in this area, the first systematic review and metaanalysis was published only in 2017:Adam et al.(2017) synthesized 179 associations from 80 studies and found consistent evidence showing that flatter cortisol slopes were associated with poorer health outcomes in 10 out of 12 subtypes of emotional and physical health (i.e.,cancer,depression,externalizing,internalizing,fatigue,inflammatory/immune response,obesity/body mass index/adiposity,other mental health,and other physical health).Moreover, they reported that the largest effect size was for the inflammatory/immune outcomes.These findings are important because they confirm that a flatter diurnal cortisol slope is associated with a broad range of health outcomes.The authors argue that these results suggest that there may be a general shared mechanism that is common to multiple disease states (Adam et al.2017).They suggest that these findings provide convincing support for a direct causal pathway linking flattened diurnal cortisol rhythms to dysregulation in multiple downstream biological and behavioral systems and thus to the development of negative health outcomes.

Adam et al. (2017,p.37) also introduce the concept of stress-related circadian dysregulation (SCiD)and argue that the association between flatter diurnal cortisol and modifications of circadian biology found by the existing research is a sign of SCiD.They suggest that future research on stress and health should focus on identifying the psychosocial origins of the early signs of stressinduced circadian dysregulations,as these changes across multiple biological systems are likely to lead to major mental and physical health problems in the future.Moreover,they argue that multiple coregulatory systems are involved in the development of SCiD,and that interventions should target multiple levels of the system (e.g., psychological, behavioral,and biological) and ultimately aim to correct the expected circadian rhythms rather than correcting those levels per se. This represents a promising area for future investigation.

# Stress and Hair Cortisol

An exciting recent advance in the area of stress and health research is the assessment of cortisol in hair.Hair cortisol provides an alternative biomarker of HPA axis activation,free from many of the limitations of other existing biological measures (saliva,urine,and blood).Follwing the discovery of glucocorticoids in hair in 20o4 (Raul et al.2004),researchers have been exploring the reliability and validity of hair cortisol measurement.A 1-cm hair segment (closest to the scalp) provides a measure of average cortisol secretion over the past month, whereas a 3-cm hair segment provides a measure of cortisol secretion over the past three months.Recent reviews have found that hair cortisol is a reliable indicator of chronic stress and is positively associated with body mass index, waist-to-hip ratio, pregnancy in women undergoing in vitro fertilization,and cardiometabolic risk factors for cardiovascular disease (CVD) such as high BP,diabetes,and adiposity(e.g., Lob & Steptoe 2019,Massey et al.2016, Stalder et al.2017,Wright et al.2015).Future research ought to incorporate hair cortisol measures in the study design and include multiple assessments,ideally in longitudinal studies.

# Effects of Stress on Autonomic Nervous System Regulation and Dynamics

The evidence for the role of the ANS in stress and health is overwhelming and extensive.The sympathetic nervous system (SNS),associated with energy mobilization and the fight-or-flight response,and the parasympathetic nervous system (PNS),associated with vegetative and restorative functions and with rest-and-digest,represent the two major branches of the ANS.In good health conditions, these systems are normall in dynamic balance, with the PNS dominating.However, as outlined above,under conditions of stress an imbalance can occur in which fight-or-flight responses are chronically activated,leading to excessive wear and tear on physiological systems (allostatic load). One mechanism that links the ANS to BP is the baroreflex.Pressure-sensitive receptors in the carotid and aortic arches sense increases and decreases in BP and transmit those signals to the brain to produce reflex adjustments in BP via the regulation of sympathetic and parasympathetic outflows in order to maintain blood flow to vital organs such as the brain and heart (Benarroch 2Oo8). Thus,ANS activity as indexed by myocardial contractility, peripheral vascular resistance,HR,and heart rate variability (HRV) works to regulate BP via the baroreflex. Importantly, there is emerging evidence for an important role of the baroreflex in long-term BP regulation (Thrasher 2006).

Autonomic imbalance,in which SNS tone is high and PNS tone is low, is associated with a wide range of disorders and diseases both mental and physical, including internalizing disorders, externalizing disorders,and psychotic disorders as wellas cardiometabolic diseases such as hypertension,coronary heart disease,and diabetes (Beauchaine & Thayer 2O15,Thayer et al.2010).

One of the leading proponents of the autonomic imbalance concept, the cardiologist Stevo Julius, noted that one of the major causes of this autonomic imbalance is the chronic activation of the defense/vigilance response (Julius 1995).From a psychological perspective this defense/vigilance response is associated with perseverative cognition (e.g., worry, rumination,and angry brooding), and a recent meta-analysis has linked such perseverative cognition to endocrine,cardiovascular, and autonomic activities such as increased cortisol, BP,and HR and decreased vagally mediated HRV (Ottaviani et al.2O15). Other meta-analyses have linked perseverative cognition to poorer health behaviors (Clancy et al.2016,2O2O).As noted above, both increased and decreased or blunted responses have been associated with increased risk.

Numerous models of stress have tried to explain these relationships. One of the early models was the recurrent activation model,or the so-called reactivity hypothesis (Krantz & Manuck 1984). In this model, repeated activation of stress systems would lead to poor health outcomes. However, evidence for the generalizability of these increased responses to laboratory tasks to real-life stress responses was found to be limited (Lovallo 2016), thus suggesting other mechanisms through which stress can influence physiological responses.Another early approach that has been largely overlooked is the prevailing state model (Manuck & Krantz 1984).In this model, the large laboratory responses generalized not to exaggerated acute responses but to large generally elevated response levels (i.e., prevailing state) in real life. More recently,as mentioned above, some scholars have proposed models suggesting that blunted responses may be associated with increased risk (Carroll et al.2O17). One way in which these various models can be reconciled is the generalized unsafety theory of stress (GUTS) (Brosschot et al.2016,2017,2018).This model proposes that the fight-or-flight response is in fact the default response that is more or less always on unless turned off by safety. This actually comports well with the autonomic imbalance model advanced by Julius and its association with the defense/vigilance response. As stated by Julius (1995),large-magnitude responses of physiological systems to threat (reactivity) are adaptive, from an evolutionary perspective,and may have been selected for in our ancestors.However, when these responses are prolonged by anticipatory activation or delayed recovery, they can lead to chronic ANS imbalance (i.e. prevailing state). Excessve activation of these systems can lead to their overuse and dysregulation (i.e., blunted responses or alostatic overload). Importantly, Julius notes that in contemporary life it is necessary to dampen this default defense response to reduce the deleterious effects of this previously adaptive rapid and strong defense reaction (Julius 1995). Research increasingly suggests that this is accomplished by the recognition of safety, and that failures to recognize safety signals,rather than perceptions of threat, may be associated with poor mental and physical health (Brosschot et al. 2016,2017,2018; Craske et al. 2012; Mayne et al. 2018).Needless to say, much more work is needed to further validate these intriguing ideas. In the next sections, we provide some of the empirical support for the association of the ANS (particularly BP and HRV) with stress and health.

# Effects of Stress on Blood Pressure, Heart Rate, Heart Rate Variability, and Their Dynamics

Numerous studies and meta-analyses have linked BP responses to mental stress to poor health outcomes.This literature is extensive,and here we only summarize some recent reviews and fundamental studies. Gasperin et al.(2Oo9) reported a meta-analysis of cohort studies on the effect of psychological stress on BP reactivity and recovery. They identified 6 eligible cohort studies representing over 34,0O0 participants. Greater BP responses to psychological stress (i.., greater reactivity as well as higher recovery levels) were associated with a $2 1 \%$ greater risk of elevated BP 11 years later relative to those with smaller BP responses.The authors suggest that management of psychological stres may be an important component of hypertension management. Landesbergis et al.(2013) examined the association between job strain and ambulatory BP.They reported the results ofa meta-analysis of 22 cross-sectional studies and showed that a single exposure to job strain was associated with higher ambulatory systolic BP (SBP)and diastolic BP (DBP).Specifically, they showed that job strain was associated with $3 . 4 3 \ \mathrm { m m H g }$ higher SBP and $2 . 0 7 \mathrm { m m H g }$ higher DBP during working hours, $2 . 5 5 \ \mathrm { m m \ H g }$ higher SBP and $1 . 9 0 \ \mathrm { m m \ H g }$ higher DBP at home,and $3 . 6 7 \mathrm { m m H g }$ higher SBP and $2 . 0 6 \mathrm { m m H g }$ higher DBP during sleep. This latter finding is particularly relevant,as sleep should represent a period of relative safety and a lack ofBP dipping at night is associated with end organ damage such as left ventricular hypertrophy, myocardial infarction, and stroke (Cuspidi et al. 2010).

Similarly, numerous studies have shown an association between ANS imbalance,as indexed by high HR and low vagally mediated HRV,and poor health outcomes. Some of this work has been summarized elsewhere (Thayer & Lane 2O07,Thayer et al.2O1O) and will not be detailed here. With respect to the role of stress,two systematic reviews have examined the efect of work stress on HRV.Jarczok et al.(2O13) systematically reviewed the association between work stress and HRV and found 19 studies representing over 8,000 employees from 10 countries published between 1976 and 2Oo8.The authors reported that adverse work conditions were generally associated with decreased HRV.A recent update of this analysis examined 18 studies published between 2013 and 2019,representing over 29,0oo participants,and reported that adverse work conditions again were generally associated with decreased HRV (Jarczok et al. 2O2O). Given that a recent large study reported that low levels of vagally mediated HRV were associated with elevated risk in the clinical range (odds ratios ranging from 1.5 to 3.5) for a wide range of biomarkers,these reviews of work stressuggest that such stress may have important implications for the risk of developing a wide range of cardiometabolic and inflammatory diseases (Jarczok et al. 2019).

Kivimaki & Steptoe (2018) provide a comprehensive review on the role of stress in the development and progression of cardiovascular disease.They show that pooling data from several large studies into mega-studies has led to an increased understanding of the role of psychological stress in CVD.For example, they reviewed studies on the etiology of CVD in the general population and reported hazard ratios ranging from 1.13 to 2.07 for the association of psychological stressors (as indexed by work stress and childhood stress) with CVD,coronary heart disease,and stroke. They conclude, however, that the evidence for scalable interventions to reduce such risk is scarce. These reviews provide strong evidence that psychological stress can have deleterious effects on health via the ANS.We next examine some primary studies that have investigated the effects of stress on ANS dynamics,including delayed recovery especially during the nighttime.

One area of emerging research focuses on circadian variation of ANS activity and its association with psychological stressAs mentioned above, nighttime or sleep should represent a period of restoration,relative safety,and associated relative decreases in SNS and increases in PNS activity. It has long been reported that elevated HR and BP at night are associated with increased mortality. For example, it has been reported that relative to those with a $1 0 \%$ or greater decrease in SBP or HR at night, individuals who had no SBP decrease but an HR decrease had a hazard ratio for mortality of 1.39,those who had a SBP decrease but no HR decrease had a hazard ratio of 1.46,and those who had neither a HR or a SBP decrease had a hazard ratio of 1.9 (Ben-Dov et al. 2007).Both acute and chronic stress have been associated with a blunted HRV increase at night.In a study of healthy young adults,it was reported that the acute stress of an impending public speech was associated with a blunted nighttime increase in HRV the night before the speech (Hall et al. 2004). Work stress has also been associated with a blunted HRV increase at night, particularly in older workers (Loerbroks et al.2010).Psychological factors have been associated with nighttime BP as well.Numerous studies have reported associations between stress, job strain, hostility, and perceived discrimination,as well as social integration, social support, and BP dipping, with the deleterious psychological factors being associated with less BP dipping and the salubrious psychological factors being associated with greater BP dipping (e.g.,Fallo et al. 2002,Fan et al. 2013, Tomfohr et al.2010).For example,a systematic review of the association between social support and BP dipping reported that greater functional social support was associated with a moderateto-large effect on BP dipping (Fortmann & Gallo 2013).These effects of stress on HRV and BP may be associated via the baroreflex.For example,one study found that lower HRV was associated with blunted BP dipping in patients with resistant hypertension (Salls et al.2O14).Another study reported that low HRV predicted the development of a nondipping BP pattern 2 years later (Dauphinot et al.2010).Future studies are needed to more fuly explicate the associations between psychological factors such as stress and circadian variations in ANS activity.

Models of the effects of stress on ANS function suggest that both large and small responses may be associated with poorer health outcomes. Ultimately,prolonged stress responses are needed to produce deleterious health effects,and data collected during periods of rest or sleep may be particularly informative. Integrative models such as GUTS may help reconcile these seemingly contradictory findings.

# The Role of Social Genomics in Elucidating the Relationship Between Stress and Health

Technological and scientific developments in our understanding of the human genome are now providing fascinating insights into the molecular mechanisms by which stress influences health. Specificall, the recognition that gene expression can be influenced by the environment, combined with the development of powerful methods that permit the simultaneous mapping of the entire human genome (Cole 2O19),has allowed investigators to explore whether and how external factors like stress regulate the activity of our genes and,therefore,influence health.

This exploration started just over a decade ago with a small study that focused not on stre but on its coconspirator, social isolation (Cole et al. 2007). Drawing on decades of research showing that socially isolated individuals have an increased risk of disease and mortality,the group examined whether patterns of gene expression differed in a systematic way between individuals reporting high versus low levels of subjective loneliness (based on responses to the UCLA Loneliness Scale)over a 3-year period.They observed that the immune cels of chronically lonely individuals were characterized by an upregulation or increased expression of pro-inflammatory genes,and the downregulation of genes associated with antiviral resistance and antibody production.Put another way, the genes associated with increasing the risk of or exacerbating inflammation-related conditions were more likely to be switched on,and those associated with protection from viral illness were more likely to be switched off.These findings provided for the first time a molecular explanation for the increased risk of disease observed in individuals with low levels of social support.It was not long before chronic stress would be listed among a host of different adverse experiences associated with this distinctive pattern of gene expression (Cole et al.2007,Miller et al. 2014), which has become known as the conserved transcriptional response to adversity (CTRA).

# Stress Results Not in the Downregulation but in the Dysregulation of Immunity

Taken together, these works on how varying indices of adversity influence the human genome have precipitated an important paradigm shift in our understanding of how stress afects health. In particular,they challenge the once dominant view that stress results in ill-health because it gives rise to widespread suppresson of the immune system. On the contrary,it is now clear that chronic stress can precipitate changes in gene expression associated with both the upregulation and the downregulation of the immune system (Cole 2013).This,in turn, helps to explain the once seemingly anomalous observation that stress can be associated with diseases involving increased activity of the immune system (e.g., inflammation-related diseases such as heart disease and autoimmune conditions) as well as diseases associated with immune suppression (e.g.,impaired responses to viral infections and vaccinations).

The discovery and characterization of the CTRA has had other notable implications for our understanding of the relationship between stress and health. One of these pertains to the debate regarding the utility of the term“stress"and whether it should only be employed in contexts where a serious threat to well-being is likely (Kagan 2O16).Pursuant to Kagan's criticism,the literature on stress and gene expression has fallen into the trap of conceptualizing stres in a variety of ways, most commonly through objective measures of adversity as well as subjective experiences (Cole et al.2011,Miller et al.2O08).Although both conceptualizations have been shown to be associated with the CTRA pattern, Cole observes that activation of this pattern is often more strongly associated with subjective experiences of adversity than with objective indices (Cole 2O13).Does this suggest that our focus should be only on indices that capture the subjective experience of stress? Perhaps.But as objective indices of stressor exposure can also be associated with genomic changes (and because some forms of stress manifest outside conscious awareness; see Mehl et al. 2017),it would seem preferable that we continue our permissive conceptualization of stress.However,rather than adopting a singular perspective, we should accommodate both objective stressors and subjective responses in models that have suficient power to delineate their combined consequences on human health (Miller & Chen 2006).

# Enhancing Our Understanding of the Role Played by Cortisol

Afurther area in which social genomics has helped our understanding of the stress-illness relationship concerns the role played by the HPA axis as a mediator.As discussed above,the activation of this axis and the subsequent release of glucocorticoids are incontrovertible consequences of stress. Indeed, the immunomodulatory properties of cortisol have played a large part in sustaining the view that stress leads to ill-health due to widespread suppresson of the immune system. However,the contradiction at the heart of this hypothesis is that if cortisol results in ill-health because it suppresses the immune system, then why does it not also protect us from conditions that arise or are exacerbated by increased immune system activity (e.g., inflammation-related and autoimmune diseases; see Miller et al.20o2,Raison & Miler 2Oo3)? This led to the evolution of the glucocorticoid resistance hypothesis (Millr et al. 2O02), which proposes that, although the HPA axis continues to produce cortisol in response to chronic stress,the persistence of inflammation in the presence of cortisol occurs because glucocorticoid receptors on immune cells become desensitized over time.In other words,the immune cels become blunted to the signal to switch off,resulting in a mild but persistent level of inflammation.Both human and animal studies have provided support for this hypothesis (Cohen et al. 2012,Miller et al. 2008).The combination of genome-wide expression analysis with bioinformatics has allowed us to understand the nature of this blunting in more detail,and the evidence suggests that chronic exposure to cortisol results in both the reduced expression of anti-inflammatory genes and the increased activity of the transcription factors promoting inflammation (Cole 2013).

# Interventions and Gene Expression: A Promising Area of Enquiry

We must acknowledge,however, that much of the evidence reviewed here of the association between indices of adversity such as stress and patterns of gene expression is correlational. This of course raises two questions.First,are these relationships causal,and if so,in what direction (i.e., does stress alter gene expression or do these patterns of gene expression give rise to stres)? Second,are observed effects amenable to change? Results from early trials show great promise. A range of interventions often deployed in the context of stress, such as yoga, mindfulness, and cognitive behavioral therapy,have shown evidence of post-intervention alterations in gene expression (Antoni etal.2012,Black et al.2013,Bower etal.2014,Creswelletal.2012).These interventions have ranged from 8 to 12 weeks in duration and have been conducted with healthy individuals and people with disease.These findings clearly ilustrate significant changes to the CTRA profile after the intervention, which is consistent with a reduction in pro-inflammatory gene expression (Antoni et al.2012,Bower et al.2014, Creswellet al.2012) and, to a lesser degree,an upregulation of antiviral immunity (Black et al.2O13).Studies in animal models have also confirmed that stress and social adversity can causally increase inflammatory gene expression and decrease antiviral gene expression (Cole et al.2015,Snyder-Mackler et al.2016).

So our current understanding of how stressinfluences health has benefited immeasurably from social genomics.It has allowed us to move away from the simplistic view that stress only results in immune suppression and to explain the paradox of stress being able to simultaneously affect both disease processes that thrive during periods of immune activity and those that require immune suppression.It has also facilitated a more sophisticated understanding of the role of the HPA axis as a mediator of the stress-health relationship.At the same time the research on interventions has served to consolidate the view not only that stress can alter our well-being,but also that psychologicalinterventions can attenuate these deleterious efects. Questions abound regarding the potency of the intervention efects and whether they could result in clinically relevant improvements in health.Similarly,itremains unclear which factors determine whether individuals exposed to stress will succumb to diseases associated with an upregulation of genes associated with inflammation or to disease associated with a downregulation of viral immunity. There is litle doubt that social genomics will continue to contribute to this discourse.

# THE CLINICAL RELEVANCE OF STRESS: THE CASE OFINFECTIOUSDISEASES

The preceding section has hopefully left the reader with litle doubt that psychological stress has physiological repercussions that have implications for the functioning of the immune system. However, the criticism leveled at much of this work has been,does it matter? In other words,are these physiological changes clinically relevant? Can they increase the risk of disease,advance the progression of coexisting conditions,or indeed influence mortality? Here we look at some of the evidence pertaining to disease risk,with a specific focus on infectious diseases.

# The Obstacles Inherent in Examining the Clinical Relevance of Stress

Attempts to understand whether stress increases the likelihood of new ilnesses have had to contend with three main challenges.The first is knowing when someone will experience stress,and it is of course common to all research in this feld.Here the challenge is that one of the hallmarks of a stressful experience is its unpredictability (when it willhappen, how bad it will be,how long it willast, etc.).Thus,one could argue that attempts to make stressful experiences predictable could diminish both the ecological validity of the stressors and the potency of the stressors' effects on emotional and physical well-being.However, psychologists are of course adept at innovative study designs and experimental manipulation,and researchers have developed a portfolio of approaches to ensure the presence of stress Most commonly this has involved experimentally controlling stressor exposure (e.g. the Trier Social Stress Test; see Kirschbaum et al. 1993),taking advantage of predictable stressful experiences (e.g., examinations; see Glaser et al. 1992),or focusing on populations experiencing known chronic stressors (e.g., caregiving; see Vedhara et al. 1999a).

The second challenge pertains to controlling the exposure to a pathogen (i.e., any biological agent capable of producing illness). To determine if stresscan give rise to illness,study participants should be exposed both to stress and to a pathogen to which they are vulnerable.This is because the experience of stress on its own is unlikely to give rise to disease within the confines of most study designs (with the notable exception of epidemiological cohorts that benefit from longitudinal follow-ups extending over many decades; see Marmot & Brunner 2005).

The third challenge is selecting an outcome measure representing health that may be regarded as clinically relevant. Initially the field was dominated by studies examining the effects of stress on experimental,or in vitro,tests of immunity.Although this literature has been influential in establishing the veracity of the effects of stress on the body, for several reasons it did not allow researchers to determine its clinical relevance,that is,its consequences for health.First, these experimental tests rely on taking samples (e.g., blood,saliva) and then measuring aspects of immunity within the sample.Thus,the assessment of the immune system is conducted outside of the body. Second,they typically focus on single aspects of the immune system,such as number of immune cels or levels of activity in response to pathogens.However, this does not reflect the ways in which the immune system protects against disease, which usually involves the coordinated activity of multiple cells, proteins,and chemicals that work together to eradicate or contain pathogens to which we are susceptible. Third, the pathogens are often synthetic, that is,they are unlikely to give rise to disease in humans. While these tests of immunity permit greater experimental control,they clearly differ considerably from the normal functioning of the immune system (Vedhara et al. 1999b). Thus, it soon became clear that experimental tests of immunity alone would not allow scholars to determine the clinical relevance of stress and other psychosocial influences for health.

The field was then revolutionized by two methodological innovations that occurred in close succession, which addressed both the problem of pathogen exposure and that of identifying acceptable indices of disease or vulnerability to disease: the viral challenge paradigm and vaccine studies.

# Viral Challenge Studies

The viral challnge paradigm was pioneered by Sheldon Cohen and colleagues. This approach typically involves quarantining healthy volunteers for several days during which they are exposed to one or more respiratory viruses (using nasal drops) and then tested for evidence of infection (determined through the presence of virus in nasal samples or a significant increase in antibody levels) and,arguably most importantly,illness(i.e.,developing a clinical cold).In their early work (Cohen et al.1991),illness was operationalized as the presence of infection and of physician and self-report ratings. More recently, they have adopted the objective markers of nasal mucus production (determined by collcting and weighing used tissues)and the ability to clear mucus from the nose (determined by the time taken for participants to taste a saccharine solution administered into the nose) (Cohen et al.2015).

In their very first study, Cohen et al.(1991) computed a stress index derived from scales measuring stressful life events, negative affect,and perceived stress,and they examined the relationship between their stress index and the likelihood of both infection and illness.They reported a dose-response relationship such that increases in stress increased the risk of developing a cold. Furthermore, these effects occurred across a range of different viruses.

This study provided clear evidence that psychological stress is associated with an increased risk of disease,specifically infectious disease,and that the efect is generalizable across a range of pathogens.Furthermore,by capturing a measure of both infection and illness, the authors were also able to establish that the relationship between stress and infection is much stronger than the relationship between stress and illness.This is perhaps unsurprising,as we would expect the immune system in otherwise healthy individuals to contain and eradicate most infections before they result in symptoms of disease.

Since this groundbreaking work, Cohen and colleagues have used their paradigm to further elucidate the connections between stress and risk of disease.Indeed,and of particular relevance to Kagan's criticism of the overuse of the term “stress,”the viral challenge studies have shown that, in terms of the common cold at least, individuals at greatest risk of illness are those contending with chronic stressors (of 1 month or longer in duration) and for whom the sources of stress are interpersonal or employment related (Cohen et al.1998).This increased risk associated with chronic stressors has also been supported by the unparalleled meta-analytical review of stress and immunity conducted by Segerstrom & Millr (2Oo4), which synthesized evidence from over 300 empirical studies conducted over 3O years and concluded that there is clear evidence that chronic stressors result in widespread suppression of the immune system.

The viral challenge studies have also illuminated the pathways by which stress may alter our vulnerability to disease. Specifically, they find that while health behaviors such as sleep quality, physical activity,and smoking are often associated with developing an illnes,these behaviors appear to largely have direct effects—i.e., they do not completely mediate the relationship between stress and ilness onset (Cohen 2Oo5). These studies have also contributed to our understanding that the relationship between stres and health is both nuanced and multifaceted,involving a range of psychosocial factors that exert both direct and indirect effects on health.For example,the relationship betwee stres, social support,and vulnerability to thecommoncold appears to vary according to how support is defined.Measures of social integration (which capture the number of roles in which the respondent has social contacts)appear to enjoy a direct relationship with disease vulnerability, such that individuals reporting greater social integration are less vulnerable to the common cold following exposure to two cold viruses; this effect is not influenced by stress(Cohen 2005,Cohen et al.1997). Conversely,a study looking at the effects of stress due to interpersonal tension,of perceived social support,and of hugging on illness risk revealed that,unlike social integration, perceived support did not have a direct effect on risk of illness In contrast, there was evidence of a buffering effect: Interpersonal tension was associated with an increased risk of illness in participants with low levels of social support,but it was unrelated to illness risk in people with high levels of perceived support. On the other hand, hugging had both a direct and protective effect on illness risk (i.e., being hugged more often was associated with a reduced risk of infection)and an indirect effect: It moderated the effectof interpersonal tension on infection risk,such that increased interpersonal tension was associated with a greater risk of illness in people who received fewer hugs (Cohen et al.2015). Of course, the recent COVID-19 outbreak highlights that the relationship between different definitions of stress and support is also likely to be affected by the nature of the infectious agent—e.g., we can speculate that hugging would not be protective in the context of COVID-19.

Taken together, the evidence from viral challenge studies has done much to quash the skeptical view that stress is a modern-day complaint with no lasting consequences for health.They have shown that stress is associated with an increased risk of illnes in otherwise healthy individuals and have highlighted the importance of precision in how we operationalize not only stress but also the myriad of psychosocial factors related to it.However,these studies remain limited by their observational designs, which require us to assume that stress is the reason some people develop illness and others do not.The causal nature ofthe relationship requires experimental designs,and it is here that the vaccine studies are beginning to provide tantalizing findings.

# Vaccine Studies

Much like the viral challenge studies, vaccine studies have provided investigators with a means of controlling the nature, timing,and virulence of the pathogen to which study participants are exposed.Moreover, because vaccinations are not intended to result in illness,vaccine studies are considered by many to be a more ethical alternative to viral challenge studies.Right after the publication of the first viral challenge study (Cohen et al. 1991), Glaser et al. (1992) reported their first vaccine challenge study.In this work they examined the relationship between negative mood (related to examinations)and health in a cohort of healthy students.Their test of health was to examine how well participants' immune systems responded to a series of hepatitis B vaccinations. Vaccines contain live,attenuated,modified,or killed pathogens (or their toxins).When administered,vaccines stimulate an immune response, the nature of which depends on the type of pathogen administered.However, most often the cascade of immune activity following vaccination ends with the production of antibodies.Thus, Glaser and colleagues gave their participants allthree hepatitis B vaccines that are part of a standard vaccine schedule.They administered each one on the third day of a 3-day exam period,and they collcted blood samples immediately prior to each vaccination to measure the antibody response to the vaccination.So,although the focus was still on measuring a single aspect of the immune system (i.e. antibody levels),this outcome conferred several advantages over the experimental tests of immunity that had up to this point dominated the field.First, antibody levels are recognized to correlate well with protection from disease (Plotkin 2010).Second, they represent the culmination of an integrated immune response. Third,they capture a response that occurs within the person (rather than in vitro) and that is precipitated following exposure to a natural, not synthetic, pathogen.Finally,the response is achieved without exposing individuals to the risk of disease.Therefore,Glaser and colleagues provided the scientific community with a test of health that offered a surrogate, but credible, measure of an individual's risk of disease.

Their results revealed that students who seroconverted after the first vaccination (i.e., who produced an increase in antibody levels indicative of protection against the disease) were those who reported the lowest levels of anxiety and stress across the exam periods.This association between measures of mood and antibody responses to vaccination has been replicated many times across a range of populations and vaccinations (Marsland et al.2O0o6, Vedhara et al.1999). Indeed,successive reviews have attested to the presence of a clear and convincing negative association between stress and antibody responses,suggesting that stress results in reduced vaccine effectiveness and, therefore,increased risk of disease (Cohen et al.2001,Pedersen et al.2O09). The public health implications of these findings are profound, given that vaccines are usually targeted at those who are at the greatest risk of disease (e.g.,the elderly),and they suggest that vaccines may be least effective in those whom they seek most to protect.

The vaccine literature has, however, also provided a growing body of work suggesting that some forms of stress (e.g.,acute stress; see Edwards et al.2O06)and factors that can be regarded as protective against stress (e.g., physical activity or positive mood; see Ansorge & Schon 1987, Edwards et al. 2O07) may actually enhance the effectiveness of vaccines. Indeed, we have also seen a corresponding increase in clinical trials in this area. These trials typically examine the effects of psychological interventions aimed at reducing stress,or at enhancing areas of functioning that protect or buffer against stress,on how effective vaccines are in protecting against disease.A recent systematic review identified nine such trials (Vedhara et al. 2O19) and reported that six of them showed some evidence of an improved antibody response following a psychological intervention. However, the review also noted significant methodological issues: There was heterogeneity in intervention approaches,with four broad categories of intervention across nine trials; effects on antibody outcomes were not uniform, as benefit across all antibody outcomes and al time points was only seen in a third of trials; and many trials did not report on adherence to the interventions or on mediating mechanisms targeted by the interventions. Thus, in keeping with the infancy of this area of research,the authors remarked this was,at best,an early signal that psychological interventions have the potential to boost the effectiveness of vaccines in protecting against disease.

# So, Does It Matter?

The viral challenge and vaccine studies have done much to demonstrate the clinical relevance of stress for health.In the context of infectious disease,at least, there is robust evidence that the experience of stress increases the risk of illnesses such as the common cold and impairs the ability of vaccines to protect the most vulnerable from diseases such as influenza.These paradigms have also been influential in illustrating that not allforms of stress are created equal, with the strongest effects repeatedly associated with chronic experiences of stress,and that a focus on stress alone will serve only to curtail our understanding of the exquisite interplay between our psychology and biology.Moreover,the relevance of these findings may not be limited to the relation between stress and the risk of infectious diseases. As evidence emerges suggesting that diseases such as asthma and heart disease may have their origins in infectious diseases (Cohen 2Oo5), these findings may have consequences for our understanding of the role of stress in health more broadly.

# THEIMPORTANCEOFEARLY-LIFEADVERSITYFORSTRESS ANDHEALTHPROCESSES

Afinal area ofresearch that requires brief consideration relates to the relation between exposure to early-life adversity and stressand health processes. Although this review focuses primarily on the effects of current stressful experiences, we want to briefly acknowledge the important research on the influence of past stressful experiences.Evidence of the serious health consequences of early-life adversity (also known as adverse childhood experiences,or ACEs) is accumulating (Bellis et al.2015,Cruz-Pereira et al.2020,Danese & McEwen 2012,Hughes et al.2017,Pakulak et al. 2018,Waehrer et al. 2O2O).Individuals who have experienced early-life adversity (e.g.,childhood trauma, domestic violence) have been found to have more physical and mental health problems in adulthood compared to individuals who have not (Belis et al.2O15,Danese & Baldwin 2017). Moreover, maltreated children and adults have been shown to have abnormally active nervous, endocrine,and immune systems (Danese & McEwen 2O12) and are significantly more likely to develop disease (i.e., cancer, diabetes, stroke); they also have a higher mortality rate compared to non-maltreated children and adults (Bellis et al.2O15).Recent findings have also found that exposure to childhood trauma is associated with increased vulnerability to suicide(Carr et al.2013; O'Connor et al.2018,2020a).In one study, O'Connor etal. (2020a) found that approximately $8 0 \%$ of adults who had attempted to end their own life had experienced at least one moderate-to-severe childhood trauma.

ACEs have also been linked to altered dynamics of the HPA axis and to persistent sensitization of the stress response system(Carpenter etal.2007,2011; Gerritsen et al.2010; Lovallo etal.2013, 2019; O'Connor et al.2016). Carpenter et al. (2007,2011) found that higher levels of childhood trauma were linked with lower cortisol reactivity to a laboratory stressor. Another study found evidence that childhood maltreatment was associated with flattened morning cortisol levels in mid-adulthood (Power et al.2012).Similar findings were also reported by Gerritsen et al.(2010), who found that early-life events were associated with lower cortisol in the morning and a flatter slope across the day in a large sample of older persons.Arecent meta-analysis found that childhood maltreatment was associated with low awakening cortisol in studies incorporating more rigorous designs (i..,agency-referred samples) (Bernard et al. 2O17). In the context of suicide risk, two recent studies found that higher levels of childhood trauma were associated with lower resting cortisol, blunted cortisol reactivity to stress,and lower cortisol levels in the morning in adulthood (O'Connor et al.2018,2020a).

A promising model linking early-life adversity to stress reactivity and health risk has been proposed by Lovallo (2O16),who has argued that ACEs cause modifications in frontolimbic brain function that may lead directly to (a) reduced stress reactivity, $( b )$ altered cognition (characterized by a shift in focus to more short-term goals and impulsive response selection),and $( c )$ unstable affect regulation.Lovallo (2O16) has also suggested that these three negative consequences influence the development of a more impulsive behavioral style that may increase the risk of addiction and the engagement in poor health behaviors.Persuasive evidence for aspects of Lovallo's model comes from the Oklahoma Family Health Patterns Project,a cohort study of healthy young adults with or without a family history of alcoholism.Irrespective of family history, the authors showed that early-life adversity was associated with reduced cortisol reactivity to an acute stressor in adulthood (Lovallo 2013,Lovallo et al.2013).Future research ought to utilize Lovallo's framework and examine further how precisely early-life adversity influences HPA axis functioning and stress responsivity. Similarly, the data reported by Kivimaki & Steptoe (2O18),which suggest that the effect of childhood stress is greater than the effect of adulthood stress on the development of cardiovascular disease,invite more research into the consequences of childhood adversity on adult health.Incorporating measures of ACEs into studies of stress and health will continue to remain an important and fruitful avenue for research.

# CONCLUSION

The cumulative science linking stressto negative health outcomes is vast. Stress can affect health directly,through autonomic and neuroendocrine responses,but also indirectly, through changes in health behaviors.The studies reviewed in this article confirm that stress has an impact on multiple biological systems and that these systems interact with each other in order to adapt and respond to changing environmental demands that are perceived as stressul. Although the field has attracted much criticism for the heterogeneity in the way stress has been conceptualized and measured, this variability has also played an important role in enhancing our understanding of what types of stress affect health and in what ways.Moreover, we have clearly moved away from a simple model according to which stress would result in too much cortisol,reduced HRV, heightened BP,or impaired immunity and toward an understanding that these systems interact and become dysregulated in more nuanced ways.We are now seeing that stress can alter the production of stress mediators in ways that can both increase and blunt, both upregulate and downregulate,all of which are likely to have serious implications for health.Future work ought to consider further the importance of early-life adversity and continue to explore how these systems interact in the context of stress and health research.

In 1950 Hans Selye wrote,“It will take many years,indeed many generations, before the details of the general adaptation syndrome are satisfactorily elucidated.In fact, we shall never truly ‘understand' this phenomenon, since the complete comprehension of life is beyond the limits of the human mind"(Selye 1950,p.1383). Well,here we are, many years and many generations later,and although we may not truly understand the entire phenomenon of stres (permissive definitions or not),we have taken giant leaps forward.There are still more exciting times ahead.

# DISCLOSURESTATEMENT

The authors are not aware of any afiliations,memberships,funding,or financial holdings that might be perceived as affecting the objectivity of this review.

# ACKNOWLEDGMENTS

We would like to thank Steve Cole,Rory O'Connor,and Ronan O'Carroll for providing feedback on an earlier draft of this article and to Sarah Wilding for asistance with some of the referencing.

# LIIEKAI UKE CIIED

Adam EK,Doane LD,Zinbarg RE,Mineka S,Craske MG, GrifthJW.2010.Prospective prediction of major depressive disorder from cortisol awakening responses in adolescence.Psychoneuroendocrinology 35:921- 31   
Adam EK, Quinn ME,Tavernier R, McQuillan MT,Dahlke KA, Gilbert KE.2017. Diurnal cortisol slopes and mental and physical health outcomes: a systematic review and meta-analysis. Psychoneuroendocrinology 83:25-41   
alAbsi M, Witmers LEJr. 2Oo3.Enhanced adrenocortical responses to stress in hypertension-prone men and women.Ann.Bebav.Med.25:25-33   
Am.Psychol. Assoc.2019.Stress in America 2019.Washington,DC: Am.Psychol. Assoc.   
Ansorge S,Schon E.1987. Dipeptidyl peptidase IV (DP IV),a functional marker of the T lymphocyte system. Acta Histocbem.82:41-46   
Antoni MH,Lutgendorf SK, Blomberg B,Carver CS,Lechner S,et al.2012.Cognitive-behavioral stress management reverses anxiety-related leukocyte transcriptional dynamics.Biol.Psychiatry 71:366-72   
Beauchaine TP,Thayer JE2015. Heart rate variabilityas a transdiagnostic biomarker ofpsychopathology. Int.J.Psycbopbysiol.98:338-50   
Bellis MA,Hughes K,Leckenby N, Hardcastle KA,Perkins C,Lowey H. 2O15.Measuring mortality and the burdenofadultdisease asociated withadversechildhood experiences inEngland: anationalsurvey J.Public Health 37:445-54   
Benarroch EE.2Oo8.The arterial baroreflex: functional organization and involvement in neurologic disease. Neurology 71:1733-38   
Ben-Dov IZ,Kark JD,Ben-Ishay D,MeklerJ,Ben-Arie L,Bursztyn M.2007.Blunted heart rate dip during sleep and all-cause mortality. Arch.Intern. Med.167:2116-21   
Bernard K,Frost A, Bennett CB,Lindhiem O.2017. Maltreatment and diurnal cortisol regulation: a metaanalysis.Psychoneuroendocrinology 78:57-67   
Black DS,Cole SW,Irwin MR, Breen E,Cyr NMS,et al. 2013.Yogic meditation reverses NF- $- \kappa \mathrm { B }$ and IRFrelated transcriptome dynamics in leukocytes of family dementia caregivers in a randomized controled trial.Psychoneuroendocrinology 38:348-55   
Boggero IA,Hostinar CE,Haak EA, Murphy MLM,Segerstrom S.2017.Psychosocial functioning and the cortisol awakening response: meta-analysis,P-curve analysis and evaluation of the evidential value of existing studies.Biol.Psycbol.129:207-30   
BowerJE,Greendale G,CrosswellADGaret D,SternliebB,etal.2014.Yogareduces inflammatorysignaling in fatigued breast cancer survivors: a randomized controlled trial.Psychoneuroendocrinology 43:20-29   
BrosschotJF,Verkuil B,ThayerJF.2O16.The default response to uncertaintyand the importance of perceived safety in anxiety and stress: an evolution-theoretical perspective.J. Anxiety Disord.41:22-34   
Brosschot JF,Verkuil B,Thayer JF.2O17.Exposed to events that never happen: generalized unsafety,the default stress response,and prolonged autonomic activity. Neurosci. Biobehav. Rev.74:287-96   
Brosschot JF,Verkuil B,Thayer JF.2018. Generalized unsafety theory of stress: unsafe environments and conditions,and the default stress response. Int. J. Environ. Res.Public Healtb 15:464   
Bunea I,Szentagotai-Tatar A,MiuAC.2017.Early-life adversityandcortisolresponse tosocialstress:ametaanalysis.Transl.Psycbiatry 7:1274 U Biol.Psycbiatry 62:1080-87   
Carpenter LL,Shattuck TT,Tyrka AR, Geracioti TD,PriceLH.2011.Effect of childhood physical abuse on cortisol stress response.Psychopharmacology 214:367-75   
Carr CP,Martins CM,Stingel AM,Lemgruber VB,Juruena MF.2013.The role of early life stress in adult psychiatric disorders: a systematic review according to childhood trauma subtypes. 7. Nerv. Ment. Dis. 201:1007-20   
Carroll D,Ginty AT,Whittaker AC,Lovallo WR,de Rooij SR.2017.The behavioural,cognitive,and neural corolaries of blunted cardiovascular and cortisol reactions to acute psychological stress.Neurosci. Biobehav.Rev.77:74-86   
Chida Y, Steptoe A.2O09. Cortisol awakening response and psychosocial factors: a systematic review and meta-analysis.Biol.Psycbol.80:265-78   
Clancy F,Prestwich A, Caperon L, O'Connor DB.2016.Perseverative cognition and health behaviours: a systematic review and meta-analysis. Front. Hum. Neurosci. 10:534   
Clancy F,Prestwich A, Caperon L,Tsipa A, O'Connor DB.2O20.The association between perseverative cognition and sleep in non-clinical populations: a systematic review and meta-analysis.Health Psycbol. Rev. In pres: htps://oi.0rg/10.1080/17437199.2019.1700819   
Clow A,Hucklebridge F,Stalder T,Evans P,Thorn L.2010. The cortisol awakening response: more than a measure of HPA axis function.Neurosci. Biobebao.Rev.35:97-103   
Cohen S.2oo5.Keynote presentationatthe Eight International Congressof Behavioral Medicine.Int.J. Behau. Med.12:123-31   
Cohen S,Doyle WJ,Skoner DP,Rabin BS,Gwaltney JM.1997.Social ties and susceptibility to the common cold. JAMA 277:1940-44   
Cohen S,Frank E,Doyle WJ,Skoner DP,RabinBS, Gwaltney JMJr.1998.Types of stressors that increase susceptibility to the common cold in healthy adults.Health Psycbol.17:214-23   
Cohen S,Gianaros PJ,Manuck SB.2016.A stage model of stress and disease.Perspect.Psycbol.Sci.11:456-63   
Cohen S,Janicki-Deverts D,Doyle WJ,Miller GE,Frank E,et al.2012.Chronic stress, glucocorticoid receptor resistance,inflammation,and disease risk.PNAS 1o9:5995-99   
Cohen S,Janicki-DevertsD,Turner RB,Doyle WJ.2015.Does hugging provide stress-bufering socialsupport? A study of susceptibility to upper respiratory infection and illess.Psycbol. Sci.26:135-47   
Cohen S,Miler GE,Rabin BS.2001. Psychological stress and antibody response to immunization: a critical review of the human literature.Psycbosom.Med. 63:7-18   
Cohen S, Tyrrell DA, Smith AP. 1991. Psychological stress and susceptibility to the common cold. $N .$ Engl.J.Med.325:606-12   
Cole SW.2013.Social regulation of human gene expresson: mechanisms and implications for public health. Am.7.Public Health 103:S84-92   
Cole SW.2019.The conserved transcriptional response to adversity. Curr: Opin. Behau.Sci. 28:31-37   
Cole SW,Capitanio JP,Chun K,Arevalo JMG,MaJ, CacioppoJT.2015.Myeloid diferentiation architecture of leukocyte transcriptome dynamics in perceived social isolation.PNAS 112:15142-47   
Cole SW,Hawkley LC,Arevalo JMG, Cacioppo JT.2011. Transcript origin analysis identifies antigenpresenting cells as primary targets ofsocially regulated gene expression in leukocytes.PNAS 108:3080-85   
Cole SW, Hawkley LC, Arevalo JMG, Sung CY, Rose RM, Cacioppo JT.2007. Social regulation of gene expression in human leukocytes. Genome Biol. 8:R189   
Craske MG,Wolitzky-Taylor KB,Mineka S,Zinbarg R, Waters AM, et al.2012.Elevated responding to safe conditions as a specific risk factor for anxiety versus depressive disorders: evidence from a longitudinal investigation.J.Abnorm.Psycbol.121:315-24   
Creswell JD,Irwin MR,Burklund LJ,Lieberman MD,Arevalo JM,et al.2012.Mindfulness-basedstress reduction training reduces loneliness and pro-inflammatory gene expresion in older adults: a small randomized controlled trial. Brain. Bebav.Immun.26:1095-101   
Cruz-Pereira JS,Rea K,Nolan YM, O'Leary OF,Dinan TG, Cryan JF.2020. Depression's unholy trinity: dysregulated stress,immunity,and the microbiome.Annu.Rev.Psychol.71:49-78

The first study to show that increases in psychological stress are associated with increased risk of developing a common cold.

The first study to show that gene expression is influenced by different levels of loneliness.

chopathology. Annu. Rev.Psycbol. 68:517-44   
Danese A,McEwen BS.2012.Adverse childhood experiences,allstasis,allostatic load and age-related disease. Pbys.Bebav.106:29-39   
Dauphinot V,Gosse P,Kossovsky MP,Schott AM, Rouch I, etal.2010.Autonomic nervous system activity is independently associated with the risk of shift in the non-dipper blood pressure pattern.Hypertens. Res. 33:1032-37   
De Rooij SR.2013.Blunted cardiovascular and cortisol reactivity to acute psychological stress: a summary of results from the Dutch Famine Birth Cohort Study.Int.J.Psychopbysiol.90:21-27   
De Vugt ME,Nicolson NA,Aalten P,Lousberg R,JolleJ,VerheyFR.2O05.Behavioral problems in dementia patients and salivary cortisol patterns in caregivers.7. Neuropsycbiat. Clin. Neurosci.17:201-7   
Dickerson SS,Kemeny ME. 2004. Acute stressors and cortisol responses: a theoretical integration and synthesis of laboratory research.Psycbol. Bull.130:355-91   
Edwards KM, Burns VE,Allen LM,McPhee JS,Bosch JA,et al.2O07.Eccentric exercise asan adjuvant to influenza vaccination in humans.Brain Bebav. Immun.21:209-17   
Edwards KM, Burns VE,Reynolds T, Carroll D,Drayson M, Ring C.2006. Acute stress exposure prior to influenza vaccination enhances antibody response in women. Brain Behau.Immun. 20:159-68   
Fallo F, Barzon L,Rabbia F,Navarrini C,Conterno A,et al. 2Oo2. Circadian blood pressure paterns and life stress.Psychother: Psycbosom.71:350-56   
Fan LB,Blumenthal JA,Hinderliter AL, Sherwood A.2013.The eect of job strain on nighttime blood pressure dipping among men and women with high blood pressure.Scand.7. Work Environ. Health 39:112   
Fortmann AL, Gall LC.2013.Social support and nocturnal blood pressure dipping: a systematic review.Am. J.Hypertens.26:302-10   
Fries E,Dettenborn L, Kirschbaum C.2O09.The cortisol awakening response (CAR): facts and future directions.Int.J.Psychopbysiol.72:67-73   
Gartland N,O'Connor DB,Lawton R,Bristow M. 2014.Exploring day-to-day dynamics of daily stressor appraisals, physical symptoms and the cortisol awakening response. Psychoneuroendocrinology 50:130-38   
Gasperin D,Netuveli G,Dias-da-CostaJS,Pattussi MP.2009.Effectof psychological stressonblood pressure increase: a meta-analysis of cohort studies. Cad.Saude Publica 25:715-26   
GerritsenL,Geerlings MI,Beekman AT,Deeg DJ,PenninxBW,ComijsHC.2010.Early and late life events and salivary cortisol in older persons.Psychol.Med.40:1569-78   
Glaser R,Kiecolt-GlaserJK,BonneauRH,Malarkey W,KennedyS,HughesJ.1992.Stress-inducedmodulation of the immune response to recombinant hepatitis B vaccine.Psychosom.Med.54:22-29   
Hall M, VaskoRBuysse D,Ombao H,Chen Q,et al. 2O04. Acute stressaffcts heart ratevariabilityuing sleep.Psycbosom.Med. 66:56-62   
Hamer M,Endrighi R,Venuraju SM,Lahiri A, Steptoe A.2012.Cortisol responses to mental stress and the progression of coronary artery calcification in healthy men and women.PLOS ONE 7:e3 1356   
Hamer M,O'DonnellK,Lahiri A, Steptoe A.2O10.Salivarycortisol responses to mental stress are asociated with coronary artery calcification in healthy men and women. Eur: Heart 7.31:424-29   
Hamer M, Steptoe A. 2012. Cortisol responses to mental stressand incident hypertension in healthy men and women.7. Clin.Endocrinol.Metab.97:E29-34   
Hill DC,Moss RH,Sykes-Muskett B,Conner M, O'Connor DB.2018.Stress and eating behaviors in children and adolescents: systematic review and meta-analysis.Appetite 123:14-22   
Hughes K,Belis MA,Hardcastle KA,SethiD,ButchartA,etal.2017.The efectof multiple adverse childhood experiences on health: a systematic review and meta-analysis.Lancet Public Health 2:e356-66   
Jarczok MN,Jarczok M,MaussD,Koenig J,LiJ,Herr RM,Thayer JF.2013.Autonomic nervous system activity and workplace stressors—a systematic review.Neurosci.Biobebau.Rev.37:1810-23   
Jarczok MN,Jarczok M, Thayer JF.202o. Work stress and autonomic nervous system activity.In Handbook ofSocioeconomic Determinants ofOccupational Health,ed.TTheorell, pp.625-56.Cham,Switz.: Sringer Int. Publ. mediated heart rate variability as a marker of health risks in human adults: proot of concept.f. Clm. Med.   
8:1940 Julius S.1995.The defense reaction: acommon denominator ofcoronary risk and blood pressure in neurogenic hypertension? Clin. Exp. Hypertens.17:375-86 Kagan J.2016.An overly permissive extension.Perspect.Psycbol. Sci.11:442-50 Kirschbaum C,Pirke K-M, Hellhammer DH.1993.The “Trier Social Stress Test”-a tool for investigating psychobiological stress responses in a laboratory setting. Neuropsychobiol. 28:76-   
81 Kivimaki M, Steptoe A. 2018.Efects of stresson the development and progression of cardiovascular disease. Nat.Rev. Cardiol.15:215 Krantz DS,Manuck SB.1984. Acute psychophysiologic reactivity and risk of cardiovascular disease: a review and methodologic critique.Psycbol. Bull. 96:435-64 Landsbergis PA, Dobson M, Koutsouras G, Schnall P.2013.Job strain and ambulatory blood presure: a meta-analysis and systematic review.Am.Public Health 103:e61-71 Lazarus RS.1999.Stress and Emotion: A New Syntbesis. New York: Springer Lob E,Steptoe A. 2O19.Cardiovascular disease and hair cortisol: a novel biomarker of chronic stress. Curr. Cardiol. Rep. 21:116 Loerbroks A, Schilling O,Haxsen V,Jarczok MN,Thayer JF,Fischer JE.2010.The fruits of one's labor: Effort-reward imbalance but not job strain is related to heart rate variability across the day in 35-44- year-old workers.J.Psychosom.Res.69:151-59 Lovallo WR.2013.Early life adversity reduces stressreactivity and enhances impulsive behavior: implications for health behaviors.Int.J.Psycbopbysiol.90:8-16 Lovallo WR.2O16.Stress and Health: Biological and Psychological Interactions.Thousand Oaks,CA: SAGE.   
3rd ed. Lovallo WR,CohoonAJ,SoroccoKH,Vincent AS,Acheson A,etal.2019.Early-life adversity and blunted stress reactivity as predictors of alcohol and drug use in persons with COMT(rs4680) Val158Met genotypes.Alcobol. Clin.Exp. Res.43:1519-27 Lovallo WR, Dickensheets SL, Myers DA, Thomas TL, Nixon SJ. 20oo. Blunted stress cortisol response in abstinent alcoholic and polysubstance-abusing men. Alcobol. Clin. Exp. Res. 24:651-   
58 Lovallo WR,Farag NH, Sorocco KH, Acheson A, Cohoon AJ, Vincent AS.2013. Early life adversity contributes to impaired cognition and impulsive behaviour: studies from the Oklahoma Family Health Patterns Project.Alcobol. Clin.Exp. Res.37:616-23 Lupien SJ,McEwen BS, Gunnar MR,Heim C.2009.Effects ofstress throughout the lifespan on the brain, behaviour and cognition.Nat. Rev.Neurosci.1O:434-45 Manuck SB, Krantz DS.1984. Psychophysiologic reactivity in coronary heart disease. Behav. Med. Update   
6:11-15 Marmot M, Brunner E.20o5.Cohort profile: the Whitehall II study.Int.7. Epidemiol.34:251-56 Marsland AL,Cohen S,Rabin BS,Manuck SB.2Oo6.Trait positive affect and antibody response to hepatitis B vaccination. Brain Behau.Immun.20:261-69 MasseyAJ,CampbellBK,Raine-Fenning N,Pincot-Allen C,PerryJ, Vedhara K.2016.Relationshipbetween hair and salivary cortisoland pregnancy in women undergoing IVF.Psycboneuroendocrinology 74:397-405 Matthews K,SchwartzJ,Cohen S,Seeman T.2oo6.Diurnal cortisoldecline is related to coronary calcification: CARDIA study. Psychosom. Med. 68:657-61 Mayne SL,Moore KA,Powell-Wiley TM,Evenson KR,Block R,Kershaw KN.2018.Longitudinalssociations of neighborhood crime and perceived safety with blood presure: the Multi-Ethnic Study of Atherosclerosis (MESA). Am. J. Hypertens.31:1024-32 McEwen BS.1998. Protective and damaging effects of stress mediators. N. Engl. J. Med. 338:171-79 McEwen BS.2ooo.Allstasis and allostatic load: implications for neuropsychopharmacology.Neuropsychopharmacology 22:108-24 McEwen BS.2018.Redefining neuroendocrinology: epigenetics of brain-body communication over the life course.Front. Neuroendocrinol.49:8-30   
McEwen BS,McEwen CA. 2016.Response to Jerome Kagan's Essay on Stress (2016). Perspect. Psycbol. Sci. 11:451-55   
McEwen BS,Seeman T.1999. Protective and damaging efects of mediators of stress: elaborating and testing the concepts of allostasis and allostatic load.Ann. N.Y. Acad. Sci. 896:30-47   
MehlMR,RsoCL,PaceTW,revaloJ,ColeSW.7.Naturalguagiicatrsofale regulation in the human immune system. PNAS 114:12554-59   
Miller GE, Chen E. 2006.Life stress and diminished expression of genes encoding glucocorticoid receptor and $\beta 2$ -adrenergic receptor in children with asthma.PNAS 103:5496-501   
Miller GE,Chen E,SzeJ,Marin T,ArevaloJM,etal.2O08.Afunctional genomic fingerprintof chronicstress in humans: blunted glucocorticoid and increased NF- $- \kappa \mathrm { B }$ signaling.Biol. Psychiatry 64:266-72   
Miller GE,Chen E,Zhou ES.2007.If it goes up, must it come down? Chronic stres and the hypothalamicpituitary-adrenocortical axis in humans.Psychol.Bull.133:25-45   
Miller GE,Cohen S,Ritchey AK.2002.Chronic psychological stressand theregulatio ofpro-infammatory cytokines: a glucocorticoid-resistance model. Health Psychol.21:531   
Miller GE, Murphy ML, Cashman R, Ma R,Ma J, et al. 2014. Greater inflammatory activity and blunted glucocorticoid signaling in monocytes of chronically stressed caregivers.Brain Behau.Immun.41:191-99   
Mortensen J,Dich N,Clark AJ,Ramlau-Hansen C,HeadJ,etal.2019.Informalcaregiving and diurnal patterns of salivary cortisol: results from the WhitehallII cohort study.Psycboneuroendocrinology 100:41-47   
Nater UM,YoungbloodLS,JonesJF,UngerER,Miller AH,etal.2Oo8.Alterations indiurnal salivarycorisol rhythmin a population-based sample of cases with chronic fatigue syndrome.Psycbosom.Med.70:298-305   
Newman E,O'Connor DB,Conner M.2o07.Daily hassles and eating behaviour: the role of cortisol reactivity. Psychoneuroendocrinology 32:125-32   
Obrist PA.1981.Cardiouascular Psychophysiology: A Perspective.New York: Plenum Press   
O'Connor DB,ArcherJ,Hair WM,Wu FCW.2001. Activational effcts of testosterone on cognitive function in men.Neuropsycbologia 39:1385-94   
O'Connor DB,Branley-BellD,GreenJ,Ferguson E,O'CarrollR,O'Connor RC.2020a.Effects of childhood trauma,daily stressand emotions on daily cortisol levels in individuals vulnerable to suicide.J.Abnorm. Psycbol.129:92-107   
O'Connor DB,Ferguson E, Green J, O'Carroll RE, O'Connor RC.2016. Cortisol and suicidal behavior: a meta-analysis.Psychoneuroendocrinology 63:370-79   
O'ConnorDB,Gartland N,O'Connor RC.202ob.Stres,cortisoland suicide risk.Int. Rev.Neurobiol.152:101- 30   
O'Connor DB,Green J,Ferguson E,O'Carroll RE,O'Connor RC.2017.Cortisol reactivity and suicidal behavior: investigating the role ofhypothalamic-pituitary-adrenal (HPA)axis responses to stress in suicide attempters and ideations.Psychoneuroendocrinology 75:183-91   
O'Connor DB, Green J,Ferguson E, O'Carroll RE,O'Connor RC.2018. Effcts of childhood trauma on cortisol levels in suicide attempters and ideations.Psychoneuroendocrinology 88:9-16   
O'Connor DB,HendrickxH,Dadd T,Talbot D,Mayes A,et al.20o9.Cortisol awakening rise in middle-aged women in relation to chronic psychological stress.Psychoneuroendocrinology 34:1486-94   
O'Connor DB,Jones F, Conner M,McMillan B,Ferguson E.2008.Efects of daily hassles and eating style on eating behavior.Health Psycbol.27:S20-31   
O'Connor DB,Walker S,Hendrickx H,TalbotD,Schaefer A. 2013.Stress-related thinking predicts the cortisol awakening response and somatic symptoms in healthy adults.Psychoneuroendocrinology 38:438-46   
Otaviani C,Thayer JF,Verkuil B,LonigroA,Medea B,etal.2015.Physiological concomitants of perseverative cognition: a systematic review and meta-analysis.Psycbol. Bul.142:231-59   
Padden C, Concialdi-McGlynn C,Lydon S.2019.Psychophysiological measures of stress in caregivers of individuals with autism spectrum disorder: a system review.Dev.Neurorebabilit.22:149-63   
Pakulak E,Stevens C,Nevill H.2018.Neuro-,cardio-,and immunoplasticity: effects ofearlyadversity.Annu. Rev.Psycbol. 69:131-56   
Pedersen AF,Zachariae R,Bovbjerg DH. 2O09.Psychological stress and antibody response to influenza vaccination: a meta-analysis.Brain Bebav.Immun.23:427-33   
Plotkin SA.2010. Correlates of protection induced by vaccination. Clin. Vacine Immunol.17:1055-65   
Powell DJ, Schlotz W.2012.Daily life stressand the cortisol awakening response: testing the anticipation hypothesis.PLOS ONE 7:e52067   
Power C,Thomas C,LiL,Hertzman C.2012. Childhood psychosocial adversityand adult cortisol patterns. Br: J.Psycbiatry 201:199-206   
Pruessner JC,Wolf OT,Hellhammer DH, Buske Kirschbaum A,von Auer K,et al.1997.Free cortisol levels after awakening: a reliable biological marker for the assessment of adrenocortical activity. Life Sci. 61:2539-49   
Raison CL,Miller AH. 2Oo3.When not enough is too much: the role of insufficient glucocorticoid signaling in the pathophysiology of stress-related disorders.Am.J.Psychiatry 160:154-65   
Raul J-S,Cirimele V,Ludes B,Kintz P.2Oo4.Detection of physiological concentrations ofcortisoland cortisone in human hair.Clin. Biocbem.37:1105-11   
Roseboom T,de Rooij S,Painter R.2o06.The Dutch famine and its long-term consequences for adult health. Early Hum.Dev.82:485-91   
Ruttle PL,Javaras KN,Klein MH, Armstrong JM,Burk LR,Esex MJ. 2013. Concurrent and longitudinal associations between diurnal cortisol and body massindex acrossadolescence.J.Adolesc.Health 52:731-37   
Salls GF,RibeiroFM, Guimaraes GM,Muxfeldt ES,Cardoso CR.2014.A reduced heart rate variability is independently associated with a blunted nocturnal blood pressure fallin patients with resistant hypertension.7. Hypertens. 32:644-51   
Sapolsky RM,Romero LM,Munck AU.20oo.How do glucocorticoids influence stress responses? Integrating permissive,suppressive,stimulatory,and preparative actions. Endocr: Rev. 21:55-89   
Schmidt-Reinwald A, Pruessner JC,Hellhammer DH, et al.199. The cortisol response to awakening in relation to different challenge tests and a 12-hour cortisol rhythm.Life Sci.64:1653-60   
Schrepf A,O'DonnellM,Luo Y,BradleyCS,Kreder K,et al.2014.Infammationand inflammatorycontrol in interstitial cystitis/bladder pain syndrome: asociations with painful symptoms.Pain 155:1755-61   
Segerstrom SC,Boggero IA,Smith GT,Sephton SE.2014. Variability and reliabilityof diurnal cortisol in younger and older adults: implications for design decisions.Psychoneuroendocrinology 49:299-309   
Segerstrom SC, Miller G. 2004. Psychological stress and the human immune system: a meta-analytic study of 30 years of inquiry. Psycbol. Bull. 130:601-30   
Segerstrom SC,O'Connor DB.2012.Stress,health and illnes: four challenges for the future.Psycbol. Health 27:128-40   
Selye H.1936.A syndrome produced by diverse nocuous agents.Nature 138(3479):32   
Selye H.1950.Stress and the general adaptation syndrome.BM7 1:1383-92   
Selye H. 1951. The general-adaptation-syndrome. Annu. Rev. Med.2:327-42   
Slavich GM. 2019. Stressnology: the primitive (and problematic) study of life stress exposure and presing need for better measurement. Brain Bebao. Immun.75:3-5   
Snyder-MacklerN,SnzJ,KohnJN,rikworthJF,MrrowS,etal.2016.Socialstatualters imeeg ulation and response to infection in macaques. Science 354(6315):1041-45   
Stalder T,Kirschbaum C,Kudielka BM,Adam EK,Pruessner JC,et al.2016.Assessment of the cortisol awakening response: expert consensus guidelines.Psychoneuroendocrinology 63:414-32   
Stalder T,Steudte-Schmiedgen S,Alexander N,Klucken T, Vater A,etal.2O17.Stress-related and basic determinants of hair cortisol in humans: a meta-analysis.Psycboneuroendocrinology 77:261-74   
Steptoe A,Hamer M,Lin J,Blackburn EH,Erusalimsky JD.2017.The longitudinal relationship between cortisol responses to mental stress and leukocyte telomere attrition.7. Clin.Endocrinol.Metab.102:962- 69   
Steptoe A,SerwinskiB.2O16.Cortisolawakening response.Intres: Concepts,Cognition,Emotion,andehaior, ed.G Fink, pp.277-83.London: Academic   
Sterling P,Eyer J.1988.Alostasis: a new paradigm to explain arousal pathology. In Handbok ofLife Stress, Cognition and Health,ed.SFisher,JReason, pp.629-49.New York:Wiley   
ThayerJF,Lane RD.2Oo7.The role ofvagal function in the risk for cardiovascular disease and mortality. Biol. Psychol.74:224-42   
Thayer JF, Yamamoto SS, Brosschot JF. 2010. The relationship of autonomic imbalance, heart rate variahilitv and cardinvacrnlar diceace rick fartore Int 7 Cavdinl 141.122_31   
Thorn L,Hucklebridge F,Evans P,Clow A.2O06.Suspected nonadherence and weekend versus week day differences in the awakening cortisol response.Psychoneuroendocrinology 31:1009-18   
Thrasher TN. 2006. Arterial baroreceptor input contributes to long-term control of blood pressure. Curr: Hypertens.Rep.8:249-54   
Tomfohr L,Cooper DC,Mills PJ,Nelesen RA,Dimsdale JE.2010.Everyday discrimination and nocturnal blood pressure dipping in black and white Americans.Psychosom. Med.72:266   
Tomiyama AJ.2019.Stress and obesity. Annu.Rev.Psycbol.70:703-18   
Turner-Cobb JM,Rixon L,Jessop DS.2011.Hypothalamic-pituitary-adrenal axis activity and upper respiratory tract infection in young children transitioning to primary school. Psycbopharmacology 214:309-17   
UKHealth Saf.Executive.2O19.Work Related Stress,Anxietyand Depresion Statistics in Great Britain 2019. London: Crown   
Vedhara K,Ayling K, Sunger K, Caldwell D,Haliday V,etal.2019.Psychological interventions as vaccine adjuvants: a systematic review.Vaccne 37:3255-66   
Vedhara K,CoxNK,Wilcock GK,Perks P,Hunt M,etal.1999a.Chronic stressin elderly carersof dementia patients and antibody response to influenza vaccination.Lancet 353:627-31   
Vedhara K,Fox J,Wang E.1999b.The measurement of stress-related immune dysfunction in psychoneuroimmunology.Neurosci.Biobebav.Rev.23:699-715   
Vedhara K,Tuinstra J,Miles JNV,Sanderman R,Ranchor AV.2Oo6.Psychosocial factors associated with indices of cortisol production in women with breast cancerand controls.Psychoneuroendocrinology 31:299- 311   
Waehrer GM,Miller TR,Silverio Marques SC,Oh DL,Burke Harris N.2020.Disease burden of adverse childhood experiences across 14 states.PLOS ONE 15:e0226134   
Wright KD,Hickman R,Laudenslager ML.2015.Hair cortisol analysis: a promising biomarker of HPA activation in older adults. Gerontologist 55:S140-45   
Wust S,Federenko I, Hellhammer DH,Kirschbaum C.2oo0. Genetic factors,perceived chronic stress and the free cortisol response to awakening. Psychoneuroendocrinology 25:707-20   
ZornJV,SchurRR,Boks MP,KahnRS,Joels M,Vinkers CH.2017.Cortisol stressreactivityacrosspsychiatric disorders: a systematic review and meta-analysis.Psychoneuroendocrinology 77:25-36